use std::net::{TcpStream, ToSocketAddrs};
use std::sync::mpsc::{channel, Sender};
use std::thread;
use std::time::Duration;
use std::env;

fn main() {
    let args: Vec<String> = env::args().collect();
    if args.len() < 2 {
        println!("Usage: cargo run <IP_ADDRESS>");
        return;
    }
    let target_ip = &args[1];
    println!("Scanning {} (Ports 1-1024)...", target_ip);

    let (sender, receiver) = channel();
    let mut children = Vec::new();

    // On scanne les 1024 premiers ports
    for port in 1..=1024 {
        let target = target_ip.clone();
        let sender = sender.clone();

        let child = thread::spawn(move || {
            if scan_port(&target, port) {
                sender.send(port).unwrap();
            }
        });
        children.push(child);
    }

    // On ferme le canal d'envoi principal
    drop(sender);

    // Réception des résultats
    let mut open_ports = Vec::new();
    for p in receiver {
        open_ports.push(p);
    }
    open_ports.sort();

    println!("\nRésultats pour {} :", target_ip);
    for port in open_ports {
        println!("Port {} est [OUVERT]", port);
    }
}

fn scan_port(ip: &str, port: u16) -> bool {
    let addr = format!("{}:{}", ip, port);
    // Timeout très court (1 sec) pour aller vite
    match addr.to_socket_addrs() {
        Ok(mut addrs) => {
            if let Some(socket_addr) = addrs.next() {
                if TcpStream::connect_timeout(&socket_addr, Duration::from_secs(1)).is_ok() {
                    return true;
                }
            }
        }
        Err(_) => {}
    }
    false
}